/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.udp.wifi.set;

import android.text.TextUtils;
import com.gprinter.udp.CommandUDP;
import com.gprinter.udp.Response;
import com.gprinter.udp.wifi.set.ResultResp;

public class SettingStaSsidCommand
extends CommandUDP {
    private boolean valid = false;
    private String ssid;

    public SettingStaSsidCommand(String ssid) {
        if (TextUtils.isEmpty((CharSequence)ssid)) {
            this.valid = false;
        } else {
            this.valid = true;
            this.ssid = ssid;
        }
    }

    @Override
    public byte[] getCommand() {
        if (!this.valid) {
            return null;
        }
        return this.getAT_WSSSID(this.ssid).getBytes();
    }

    @Override
    public Response resolveResponseData(long uuid, byte[] data) {
        try {
            if (data != null) {
                String response = new String(data);
                ResultResp resultResp = new ResultResp();
                if (response.contains("+ok")) {
                    resultResp.setResult(true);
                } else {
                    resultResp.setResult(false);
                }
                return resultResp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getAT_WSSSID(String str) {
        if (!str.equals("")) {
            String cmd = "AT+WSSSID=";
            cmd = cmd + str;
            cmd = cmd + "\r";
            return cmd;
        }
        return "";
    }
}

